% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialExperiment-colData.R
\name{SpatialExperiment-colData}
\alias{SpatialExperiment-colData}
\alias{colData}
\alias{colData<-}
\alias{colData<-,SpatialExperiment,DataFrame-method}
\alias{colData<-,SpatialExperiment,NULL-method}
\title{SpatialExperiment colData}
\usage{
\S4method{colData}{SpatialExperiment,DataFrame}(x) <- value

\S4method{colData}{SpatialExperiment,NULL}(x) <- value
}
\arguments{
\item{x}{a \code{\link{SpatialExperiment}}}

\item{value}{a \code{\link[S4Vectors]{DataFrame}}}
}
\value{
a \code{\link{SpatialExperiment}} object with updated \code{colData}
}
\description{
The \code{\link{SpatialExperiment}} class provides a modified \code{colData}
setter, which ensures that the \code{SpatialExperiment} object remains valid.
}
\details{
The \code{colData} setter performs several checks to ensure validity. If the
replacement \code{colData} does not contain a \code{sample_id} column, the
existing \code{sample_id}s will be retained. If the replacement
\code{colData} contains \code{sample_id}s, a check is performed to ensure the
number of unique \code{sample_id}s is the same, i.e. a one-to-one mapping is
possible. If the replacement is \code{NULL}, the \code{sample_id}s are
retained. In addition, checks are performed against the \code{sample_id}s in
\code{\link{imgData}}.
}
\examples{
example(SpatialExperiment)

# empty replacement retains sample identifiers
colData(spe) <- NULL
names(colData(spe))

# replacement of sample identifiers
# requires one-to-one mapping

## invalid replacement

tryCatch(
  spe$sample_id <- seq(ncol(spe)),
  error = function(e) message(e)) 
  
## valid replacement  
  
old <- c("section1", "section2")
new <- c("sample_A", "sample_B")
idx <- match(spe$sample_id, old)

tmp <- spe
tmp$sample_id <- new[idx]
table(spe$sample_id, tmp$sample_id)
}
