#' MIBI-TOF Breast cancer intensities
#'
#' @description
#' This is a single MIBI-TOF data of breast cancer from patient 6 of the
#' Keren et al 2018 dataset.
#'
#'
#' @usage data(kerenSCE)
#'
#' @format kerenSCE a SingleCellExperiment object
#' @aliases
#' kerenSCE
#'
#' @references Keren, L., Bosse, M., Marquez, D., Angoshtari, R., Jain,
#' S., Varma, S., Yang, S. R., Kurian, A., Van Valen, D., West, R., Bendall,
#' S. C., & Angelo, M. (2018). A Structured Tumor-Immune Microenvironment in
#' Triple Negative Breast Cancer Revealed by Multiplexed Ion Beam Imaging.
#' Cell, 174(6), 1373-1387.e1319. ([DOI](https://doi.org/10.1016/j.cell.2018.08.039))
#'
#'
"kerenSCE"


#' Kontextual results from kerenSCE
#'
#' @description
#' This is a kontextual results data.frame created using Kontextual on the kerenSCE dataset.
#'
#'
#' @usage data(kerenKontextual)
#'
#' @format kerenKontextual a kontextual results object.
#' @aliases
#' kerenKontextual
#'
#'
#'
"kerenKontextual"
