% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSNEVisualization.R
\name{tsneVisualization}
\alias{tsneVisualization}
\title{Visualization of marker proteins by t-SNE map}
\usage{
tsneVisualization(protein.data, markerProteins, dims, theta, perplexity)
}
\arguments{
\item{protein.data}{data.frame; fractionated proteomics data}

\item{markerProteins}{character; robust marker proteins, gene
symbols, that are present in the given data and overlapped with package's
marker protein list.}

\item{dims}{integer; dimensionality}

\item{theta}{numeric; Speed/accuracy trade-off ,increase for less accuracy}

\item{perplexity}{integer; Perplexity parameter}
}
\value{
tsneMap.df
}
\description{
The marker proteins are visualized in 3D t-SNE map
to see the distributions of the marker proteins.
}
\examples{
{

df <- loadData(SubCellBarCode::hcc827Ctrl)

c.prots <- calculateCoveredProtein(rownames(df), markerProteins[,1])

set.seed(21)
tsneMap.df <- tsneVisualization(protein.data = df,
markerProteins = c.prots[1:20],
dims = 2, theta = c(0.4), perplexity = c(5))
}

}
