% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeature.R
\name{selectFeature}
\alias{selectFeature}
\title{Title
Select features}
\usage{
selectFeature(HOSVD, input_all, de = 1e-04, p0 = 0.01, breaks = 100)
}
\arguments{
\item{HOSVD}{output from HOSVD}

\item{input_all}{Selected singular value IDs}

\item{de}{Initial value for optimization of standard deviation}

\item{p0}{Threshold P-value}

\item{breaks}{The number of bins}
}
\value{
List that includes selected features and computed P-value
}
\description{
Title
Select features
}
\examples{
set.seed(2)
require(rTensor)
HOSVD <- hosvd(as.tensor(array(runif(10000*3*3),c(10000,3,3))),c(10,3,3))
input_all <- c(2,2)
index <- selectFeature(HOSVD,input_all,de=0.01,p0=0.01)
}
