% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{analysis_from_table}
\alias{analysis_from_table}
\title{Analysis from Input Table}
\usage{
analysis_from_table(
  inputData,
  mode = "h2h",
  interest_min_LFC = -Inf,
  interest_max_LFC = Inf,
  control_min_LFC = -0.25,
  control_max_LFC = 0.25,
  interest_min_pval = 0,
  interest_max_pval = 0.05,
  control_min_pval = 0.5,
  control_max_pval = 1,
  expressed = TRUE,
  encodeFilter = FALSE,
  TFfilter = NULL,
  method = "ora"
)
}
\arguments{
\item{inputData}{A data frame containing gene expression data.}

\item{mode}{Character string specifying the mode: 'h2h', 'm2h', 'm2m'.}

\item{interest_min_LFC}{Minimum LFC for selected genes of interest.}

\item{interest_max_LFC}{Maximum LFC for selected genes of interest.}

\item{control_min_LFC}{Minimum LFC for control genes.}

\item{control_max_LFC}{Maximum LFC for control genes.}

\item{interest_min_pval}{Minimum p-value for genes of interest.}

\item{interest_max_pval}{Maximum p-value for genes of interest.}

\item{control_min_pval}{Minimum p-value for control genes.}

\item{control_max_pval}{Maximum p-value for control genes.}

\item{expressed}{Logical; filter TFs expressed in input data.}

\item{encodeFilter}{Logical; apply ENCODE filtering to ChIP-seq data.}

\item{TFfilter}{Character vector of transcription factors to filter (optional).}

\item{method}{Analysis method: 'ora' (overrepresentation) or 'gsea' (gene set enrichment).}
}
\value{
A matrix with calculated statistics (e.g., p-values, odds ratios).
}
\description{
Performs gene expression analysis, filtering genes and
TFs based on specified thresholds. It calculates statistics using 
overrepresentation analysis (ORA) or gene set enrichment analysis (GSEA).
}
\examples{
data('hypoxia_DESeq',package='TFEA.ChIP')
res <- analysis_from_table(hypoxia_DESeq, interest_min_LFC = 1)
}
