% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSets.R
\name{filterSets}
\alias{filterSets}
\alias{filterSets,GeneSet,character,numeric,numeric-method}
\alias{filterSets,GeneSetCollection,character,numeric,numeric-method}
\title{Filter a Named List of Sets by Size}
\usage{
filterSets(x, background = NULL, min_size = 5L, max_size = Inf, ...)

\S4method{filterSets}{GeneSet,character,numeric,numeric}(x, background = NULL, min_size = 5L, max_size = Inf, ...)

\S4method{filterSets}{GeneSetCollection,character,numeric,numeric}(x, background = NULL, min_size = 5L, max_size = Inf, ...)
}
\arguments{
\item{x}{a named list of sets. Elements must be of type \code{"character"}.}

\item{background}{character; optional character vector. \code{x} will be
filtered to only those elements of \code{background}.}

\item{min_size}{integer (\eqn{\geq 1}); the minimum allowable set size.}

\item{max_size}{integer (\eqn{\geq 1}); the maximum allowable set size.}

\item{...}{additional arguments are not currently used.}
}
\value{
A named list of sets at most the same size as \code{x}.
}
\description{
Given a named list of sets, filter to those that contain at
least \code{min_size} and no more than \code{max_size} elements. The sets
are optionally restricted to elements of \code{background} before filtering
by size.
}
\examples{
x <- list("A" = c("a", "b", "c"),
          "B" = c("a", "a", "d", "e", NA), # duplicates and NA
          "C" = c("f", "g"))

# All sets have at least 2 elements,
# so this just removes duplicates and NA
filterSets(x, min_size = 2L)

# Limit scope of sets before filtering
filterSets(x, min_size = 2L, background = c("a", "c", "e", "z"))
}
