% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGMT.R
\name{readGMT}
\alias{readGMT}
\title{Read GMT File to a Named List of Sets}
\usage{
readGMT(path, check = TRUE)
}
\arguments{
\item{path}{character; path to a GMT file. Files may include one additional
extension after ".gmt", such as ".gmt.gzip".}

\item{check}{logical; check that \code{path} points to a valid GMT file. If
\code{FALSE}, files with different extensions may be read, so long as they
are in the expected format.}
}
\value{
A named list of character vectors.
}
\description{
Create a named list of sets from a GMT file, or a file
structured like a GMT.
}
\details{
The second entry in each line of the GMT file is assumed to be a URL
or some other additional information, so it is discarded.
}
\note{
Similar to \code{fgsea::gmtPathways}.
}
\examples{
path <- system.file("extdata", "c5.go.v2023.2.Hs.symbols.gmt.gz",
                    package = "TMSig")

x <- readGMT(path)

head(names(x)) # First 6 gene set names

x[1] # first set
}
