% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tppccrPlotCurves.R
\name{tppccrPlotCurves}
\alias{tppccrPlotCurves}
\title{Plot dose response curves}
\usage{
tppccrPlotCurves(
  data = NULL,
  fcTable = NULL,
  curvePars = NULL,
  resultPath = NULL,
  ggplotTheme = tppDefaultTheme(),
  nCores = "max",
  verbose = FALSE
)
}
\arguments{
\item{data}{list of expressionSet objects containing protein fold changes, as 
well as fitted curve parameters.}

\item{fcTable}{optional long table with fold changes for each experiment. 
Can be provided instead of the input argument \code{data}.}

\item{curvePars}{optional long table of curve parameters per protein and 
experiment. Can be provided instead of the input argument \code{data}.}

\item{resultPath}{location where to store dose-response curve plots.}

\item{ggplotTheme}{ggplot theme for dose response curve plots.}

\item{nCores}{either a numerical value given the desired number of CPUs, or 
'max' to automatically assign the maximum possible number (default).}

\item{verbose}{print name of each plotted protein to the command line as a 
means of progress report.}
}
\value{
A list of expressionSet objects storing fold changes,
as well as row and column metadata. In each expressionSet \code{S}, the fold 
changes
  can be accessed by \code{Biobase::exprs(S)}. Protein expNames can be accessed by 
  \code{featureNames(S)}. Isobaric labels and the corresponding 
  concentrations are 
  returned by \code{S$label} and \code{S$concentration}. Paths to the 
  produced plots are stored in code{featureData(S)$plot}.
}
\description{
\code{tppccrPlotCurves} plots the logistic dose response curves, 
as well as the underlying fold
  change measurements for each TPP-CCR experiment in a study.
}
\details{
\code{data} is a list of expressionSet objects created by
\code{\link{tppccrCurveFit}}. It contains 
the isobaric labels and administered drug concentrations in the 
\code{phenoData} and user-defined protein properties (including dose response 
curve parameters) in the \code{featureData}. Protein IDs are stored in the 
\code{featureNames}.

Measurements and compound effects for curve fitting can be provided 
by the arguments \code{fcTable} and \code{cpdEffects}, instead of being 
stored in expressionSets in \code{data}. 
  
If specified, \code{fcTable} needs to be a long 
table with column names "id" (the protein names), "concentration" (the fold 
changes), "labelName" (the isobaric label to each measurement), and 
"experiment" (e.g. "Vehicle_1" or "Panobinostat_1").
  
If specified, \code{curvePars} needs to be a long 
table with column names "id" (the protein names), "param" (curve parameter 
per protein and experiment, see TPP:::drCurveParamNames(names=TRUE, 
info=FALSE) for possibilities), and 
"experiment" (e.g. "Vehicle_1" or "Panobinostat_1").

The dose response curve plots will be stored in a subfolder with name 
\code{DoseResponse_Curves} at the location specified by \code{resultPath}.
}
\examples{
data(hdacCCR_smallExample)
tppccrData <- tppccrImport(configTable=hdacCCR_config, 
                           data=hdacCCR_data)
tppccrNorm <- tppccrNormalize(data=tppccrData)
tppccrTransformed <- tppccrTransform(data=tppccrNorm)
tppccrFitted <- tppccrCurveFit(data=tppccrTransformed, nCores=1)
hdacSubset <- sapply(tppccrFitted, function(d)d[grepl("HDAC", rownames(d)),])
tppccrPlotted <- tppccrPlotCurves(hdacSubset, resultPath=getwd(), nCores = 1)

}
\seealso{
\code{\link{tppccrCurveFit}},\code{\link{tppDefaultTheme}}
}
