% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpptrFTest.R
\name{tpptrFTest}
\alias{tpptrFTest}
\title{Analyze spline fits to detect differential behavior over time}
\usage{
tpptrFTest(fittedModels, doPlot = FALSE, resultPath = NULL)
}
\arguments{
\item{fittedModels}{a table of fitted spline models (produced by \code{tpptrFitSplines}).}

\item{doPlot}{boolean value indicating whether QC plots should be produced.
Currently, QC plots comprise distributions of the F statistics, and the 
p-values before/ after Benjamini Hochberg adjustment.}

\item{resultPath}{location where to store QC plots, if \code{doPlot} = TRUE.}
}
\value{
A long table containing the hypothesis test results per protein.
}
\description{
Analyze fitted natural spline models and look for 
differential behaviour between conditions by a moderated F-test.
}
\details{
If \code{doPlot} is \code{TRUE}, but no \code{resultPath} is 
specified, the plots will be prompted to the active device.

The moderated F-statistic is calculated by the following equation:
...
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(configTable = hdacTR_config, data = hdacTR_data)
normResults <- tpptrNormalize(data = tpptrData, normReqs = tpptrDefaultNormReqs())
normData_eSets <- normResults$normData
fitData <- tpptrTidyUpESets(normData_eSets)
fits <- tpptrFitSplines(data = fitData, factorsH1 = "condition", nCores = 1, splineDF = 4:5)
testResults <- tpptrFTest(fittedModels = fits)

}
\seealso{
\code{\link{ns}, \link{squeezeVar}}
}
