% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpptrSplineFitAndTest.R
\name{tpptrSplineFitAndTest}
\alias{tpptrSplineFitAndTest}
\title{Perform spline fitting and analyze by moderated F-test}
\usage{
tpptrSplineFitAndTest(
  data,
  factorsH1,
  factorsH0 = character(),
  resultPath = NULL,
  doPlot = TRUE,
  nCores = "max",
  splineDF = 3:7,
  additionalCols = NULL,
  verbose = NULL,
  ggplotTheme = NULL
)
}
\arguments{
\item{data}{the data to be fitted.}

\item{factorsH1}{which factors should be included in the alternative model?}

\item{factorsH0}{which factors should be included in the null model?}

\item{resultPath}{location where to store the spline plots per protein.}

\item{doPlot}{boolean value indicating whether melting curves should be 
plotted, or whether just the curve parameters should be returned.}

\item{nCores}{either a numerical value given the desired number of CPUs, or 
'max' to automatically assign the maximum possible number (default).}

\item{splineDF}{degrees of freedom for natural spline fitting.}

\item{additionalCols}{additional annotation per protein to append to the 
result table.}

\item{verbose}{DEPRECATED}

\item{ggplotTheme}{DEPRECATED.}
}
\value{
A data frame in wide format with one row per protein. It contains 
the smoothing spline parameters and F-test results obtained by comparing 
the null and alternative models.
}
\description{
A wrapper function around the functions \code{tpptrFitSplines}, 
\code{tpptrFTest}, \code{tpptrPlotSplines}, which fits natural splines to
  all proteins in a dataset and detect differential behavior between
  conditions by a moderated F-test. The results are formatted as a wide table
  with one row per protein. This table contains all the original data, the
  test results, and (optionally) additional annotation columns for each 
  protein.
}
\details{
Plots of the natural spline fits will be stored in a subfolder with 
  name \code{Spline_Fits} at the location specified by \code{resultPath}.
  
  Argument \code{data} can either be long table, or a list of expressionSets
  as returned by \code{\link{tpptrImport}}. If a long table, it needs to
  contain the following columns: 'uniqueID' (identifier), 'x' (independent
  variable for fitting, usually the temperature) and 'y' (dependent variable
  for fitting, usually the relative concentration).
  
  Argument \code{splineDF} specifies the degrees of freedom for natural
  spline fitting. As a single numeric value, it is directly passed on to the
  \code{splineDF} argument of \code{splines::ns}. Experience shows that
  \code{splineDF = 4} yields good results for TPP data sets with 10
  temperature points. It is also possible to provide a numeric vector. In
  this case, splines are fitted for each entry and the optimal value is
  chosen per protein using Akaike's Information criterion.
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(configTable = hdacTR_config, data = hdacTR_data)
fitData <- tpptrTidyUpESets(tpptrData)
hdacSplineFits <- tpptrSplineFitAndTest(data = fitData,
                                        factorsH1 = "condition",
                                        nCores = 1,
                                        splineDF = 4:5,
                                        doPlot = FALSE)
# Show estimated splines for HDAC1:
filter(hdacSplineFits, Protein_ID == "HDAC1")
# -> Which proteins showed significant condition effects?
hdacSplineFits \%>\% filter(p_adj_NPARC <= 0.01) \%>\% select(Protein_ID, p_adj_NPARC)
# Quality control: test for replicate-specific effects:
 testResults <- tpptrSplineFitAndTest(data = fitData,
                                     factorsH1 = "replicate",
                                     nCores = 1,
                                     splineDF = 4,
                                     doPlot = FALSE)
# -> Which proteins showed significant replicate effects?
testResults \%>\% filter(p_adj_NPARC <= 0.01) \%>\% select(Protein_ID, p_adj_NPARC)

}
\seealso{
\code{\link{ns}, \link{AICc}}
}
