% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctness.R
\name{is.compliant}
\alias{is.compliant}
\title{is.compliant}
\usage{
is.compliant(
  x,
  err.fun = "[ERR]",
  stage = !(all(is.null(x$stages)) || all(is.na(x$stages)))
)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{err.fun}{string which identifies the function which called is.compliant}

\item{stage}{boolean flag to check x$stage datagframe}
}
\value{
on error stops the computation
}
\description{
Check if 'x' is compliant with TRONCO's input: that is if it has dataframes 
x$genotypes, x$annotations, x$types and x$stage (optional)
}
\examples{
data(test_dataset)
is.compliant(test_dataset)

}
