% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntTracks.R
\name{trackSpec}
\alias{trackSpec}
\alias{trackSpec<-}
\title{Track Spec}
\usage{
trackSpec(track, which = c("background", "height", "label"))

trackSpec(track, which = c("background", "height", "label")) <- value
}
\arguments{
\item{track}{A TnTTrack object.}

\item{which}{Character vector, can be "background", "height" or "label".}

\item{value}{Value to set: background should be character, height should be numeric,
label should be character. If length of \code{which} is bigger than one, \code{value}
should be a list with the same length.}
}
\value{
For \code{trackSpec}, if length of \code{which} equals to one, return a
    scalar character or numeric, if length of \code{which} is bigger than one,
    return as a list.
}
\description{
Height, background and label are common options of all tracks, use these functions
to get and set them.
}
\examples{
track <- BlockTrack(GRanges("chr13", IRanges(6, 9)))
trackSpec(track, "background")
trackSpec(track, c("height", "label"))
trackSpec(track, c("height", "label")) <- list(100, "my range")
trackSpec(track, "background") <- "green"
trackSpec(track)
}
