% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugTimeResponseCurve.R
\name{drugTimeResponseCurve}
\alias{drugTimeResponseCurve}
\title{Compares viabilities at a given dose over different experimental durations}
\usage{
drugTimeResponseCurve(
  tSet,
  duration = NULL,
  cell_lines = NULL,
  dose = NULL,
  drugs = NULL,
  summarize_replicates = TRUE,
  line_width = 1,
  point_size = 2.5,
  verbose = TRUE,
  ggplot_args = NULL
)
}
\arguments{
\item{tSet}{\code{ToxicoSet} A ToxicoSet to be plotted in
this figure}

\item{duration}{\code{character} A vector of durations to include in the plot.}

\item{cell_lines}{\code{character} A vector of cell lines to include in the
plot.}

\item{dose}{\code{character} A vector of dose levels to be included in the
plot. Default to include all dose levels available for a drug. Must include
at minimum two dose levels, one of witch is "Control".}

\item{drugs}{\code{character} A drugs or pair of drugs to be plotted.}

\item{summarize_replicates}{\code{logical} If TRUE will average viability
across replicates for each unique drug-dose-duration combination.}

\item{line_width}{\code{numeric} A number specifying the thickness of lines
in the plot, as passed to size in geom_line(). Defaults to 1.}

\item{point_size}{\code{numeric} A number specifying how large points should
be in the plot, as passed to size in geom_point(). Defaults to 2.5.}

\item{verbose}{\code{boolean} Should warning messages about the data passed
in be printed?}

\item{ggplot_args}{\code{list} A list of ggplot2 functions which can be
called using the plot + function() syntax. This allows arbitrary
customization of the plot including changing the title, axis labels,
colours, etc. Please see the included examples for basic usage or ggplot2
documentation for advanced customization. Alternatively, you could assign
the return value to a variable and add the customization yourself using
plot + function().}
}
\value{
Plot of the viabilities for each drugs vs time of exposure
}
\description{
This function generates a plot visualizing the relationship between gene
expression, time and dose level for the selected tSet. The plot is generated
with ggplot2 and can be customized using ggplot plot + function() syntax.
}
\examples{
  library(ggplot2)

  # Default settings
  plot <- drugTimeResponseCurve(TGGATESsmall, cell_lines = "Hepatocyte",
  dose = c("Control", "Low", "Middle"), drugs = treatmentNames(TGGATESsmall)[6],
  duration = c("2", "8", "24"))

  # Customize title, x/y labels, x/y limits, colour palette and define
  # custom ticks for x axis using the function argument ggplot2_args
  customizations <- list(labs(title= 'My Custom Title', ylab = 'The y-axis'),
                         xlim(c(2, 24)), ylim(c(99,105)),
                         scale_color_brewer(palette="Set1"),
                         scale_x_continuous(breaks=c(2, 8, 24),
                           labels = c("Two", "Eight", "Twenty-Four"))
                         )

   if(interactive()) {
      drugTimeResponseCurve(TGGATESsmall, cell_lines = "Hepatocyte",
        dose = c("Control", "Low", "Middle"),
        drugs = treatmentNames(TGGATESsmall)[6], duration = c("2", "8", "24"),
        ggplot_args = customizations)
   }

   # Customize the plot using standard ggplot2 syntax
   if(interactive()) {
      plot + labs(title= 'My Custom Title', ylab = 'The y-axis') +
        xlim(c(2, 24)) + ylim(c(99,105)) + scale_color_brewer(palette="Set1")
   }

}
