% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFeature.R
\name{plotFeature}
\alias{plotFeature}
\title{Plot features of interest}
\usage{
plotFeature(Data, tVectIn = NULL, featureNames, showFit = TRUE,
  simple = FALSE, showLegend = TRUE, trendyOutData = NULL,
  cexLegend = 1, legendLocation = "side", xlab = "Time",
  ylab = "Normalized Expression", segColors = c("chartreuse3",
  "coral1", "black", "cornflowerblue"), customTitle = NULL,
  customLabels.x = NULL, spacing.x = NULL)
}
\arguments{
\item{Data}{a matrix of normalized expression measurements. Rows are 
genes/features and columns are samples.}

\item{tVectIn}{a numerical vector indicating the time-points or the 
order of samples. If it is NULL (default), then the time/order 
will be assumed to be equaly spaced from 1:N (N is number of samples).}

\item{featureNames}{a list of genes or features to plot}

\item{showFit}{whether to plot the segmented regression 
fitting (default is TRUE)}

\item{simple}{if TRUE the plot will not highlight the breakpoints and segments 
and will only display a black fitted line. (default is FALSE)}

\item{showLegend}{if TRUE and simple=FALSE then a legend will be output (default = TRUE)}

\item{trendyOutData}{segmented regression fitting result from 
running trendy(); if showFit is TRUE and trendyOutData is NULL, then the
segmented regression will be fit for each of the genes and it may 
take longer to run}

\item{cexLegend}{cex option for sizing of legend text, default is 1.}

\item{legendLocation}{whether to place the legend to the right 'side' of each plot or at the 'bottom' of a multo-panelled plot (default is 'side').}

\item{xlab}{x-axis name}

\item{ylab}{y-axis name}

\item{segColors}{define colors for the 'breakpoint', and 'up', 'same', 'down' segments (default: segColors =     c("chartreuse3", "coral1", "black", "cornflowerblue"))}

\item{customTitle}{default is set the plot title as the name of the feature. Otherwise this should be a named vector, 
with the featureName as the name and the element as the desired plot title. (i.e. customTitle <- c("MyTitle" = gene1)).}

\item{customLabels.x}{specify x-axis tick labels instead of using the default values from tVectIn.}

\item{spacing.x}{specify x-axis tick spacing, smaller values give more tick marks.}
}
\value{
plot of gene expression and fitted line
}
\description{
plot each feature with (or without) the fitted trend.
}
\examples{
 d1 <- matrix(c(c(rnorm(50,5,1),sort(rnorm(50, 15, 5))), rnorm(100, 50,10)), 2, 100, TRUE)
 rownames(d1) <- c("g1","g2")
 colnames(d1) <- paste0("time", seq_len(100))
 plotFeature(d1, featureNames=c("g1","g2"))
}
\author{
Ning Leng and Rhonda Bacher
}
