% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waldUMI4C.R
\name{waldUMI4C}
\alias{waldUMI4C}
\title{DESeq2 Wald test for differential contacts}
\usage{
waldUMI4C(
  umi4c,
  query_regions = NULL,
  subset = "sum",
  design = ~condition,
  normalized = TRUE,
  padj_method = "fdr",
  padj_threshold = 0.05
)
}
\arguments{
\item{umi4c}{UMI4C object as generated by \code{makeUMI4C} or the
\code{UMI4C} constructor.}

\item{query_regions}{\code{GRanges} object containing the coordinates of the 
genomic regions you want to use to perform the analysis in specific genomic 
intervals. Default: NULL.}

\item{subset}{If \code{query_regions} are provided, how to subset the UMI4C
object:  "sum" for summing raw UMIs in fragments overlapping 
\code{query_regions} (default) or "overlap" for selecting overlapping fragments.}

\item{design}{A \code{formula} or \code{matrix}. The formula expresses how
the counts for each fragment end depend on the variables in \code{colData}.
See  \code{\link[DESeq2]{DESeqDataSet}}.}

\item{normalized}{Logical indicating if the function should return normalized
or raw UMI counts.  Default: TRUE.}

\item{padj_method}{The method to use for adjusting p-values, see
\code{\link[stats]{p.adjust}}.  Default: fdr.}

\item{padj_threshold}{Numeric indicating the adjusted p-value threshold to
use to define significant differential contacts.  Default: 0.05.}
}
\value{
\code{UMI4C} object with the DESeq2 Wald Test results, which can be
accessed using \code{\link{resultsUMI4C}}.
}
\description{
Using a \code{UMI4C} object, infers the differences between conditions 
specified in \code{design} using a Wald Test from \code{DESeq2} package.
}
\examples{
data("ex_ciita_umi4c")

umi_dif <- waldUMI4C(ex_ciita_umi4c)
}
