% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io.R
\name{FilterChimericJuncs}
\alias{FilterChimericJuncs}
\title{FilterChimericJuncs}
\usage{
FilterChimericJuncs(
  All_junctions,
  chromFilter = TRUE,
  strandFilter = TRUE,
  genomicDistance = c(200, 1e+05),
  canonicalJuncs = TRUE,
  fileID = c(-1),
  chrM_Filter = TRUE,
  invertReads = FALSE
)
}
\arguments{
\item{All_junctions}{: data.table of chimeric reads from STAR aligner}

\item{chromFilter}{: when TRUE (default) both chimera parts have to align to same chromosome}

\item{strandFilter}{: when TRUE (default) both chimera parts have to align to same strand}

\item{genomicDistance}{: minimum and maximum distance filters of chimeric reads on chromosome. Only is applied
if ChromFilter is TRUE and StrandFilter is TRUE}

\item{canonicalJuncs}{: Will include any canonical junctions (default TRUE). Note STAR keeps canonical junctions that do not conform to aligner rules.}

\item{fileID}{: Specify a file index. Useful if planing to concatenating all data sets into a single table.}

\item{chrM_Filter}{: Filter out mitochondrial chimeric reads (default TRUE)}

\item{invertReads}{: Boolean that specifies in read strand should be inverted (default FALSE).}
}
\description{
A generic function that filters STAR chimeric junction files on certain genomic criteria (eg strand, same chromosome etc).
Useful filter to remove the most obvious false positives. The default filter settings are suitable for circRNA
 discovery in humans / mice data sets.
}
\examples{
extdata_path <- system.file("extdata",package = "Ularcirc")
chimeric.file <- paste0(extdata_path,"/SRR444655_subset.Chimeric.out.junction.gz")
chimericsDT <- Ularcirc::loadSTAR_chimeric(chimeric.file,returnColIdx = 1:14)
chimericsDT$filtered <- Ularcirc::FilterChimericJuncs(chimericsDT$data_set, canonicalJuncs = TRUE)

}
\seealso{
SelectUniqueJunctions, loadSTAR_chimeric
}
