% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io.R
\name{loadSTAR_chimeric}
\alias{loadSTAR_chimeric}
\title{loadSTAR_chimeric}
\usage{
loadSTAR_chimeric(filename = NULL, ID_index = 0, returnColIdx = 1:21)
}
\arguments{
\item{filename}{:  filename of the STAR chimeric output file.
Can be gzipped}

\item{ID_index}{:  An index (single integer) which will be added
as a separate column in the returned data table. Useful when
collating multiple files into one large matrix like object.}

\item{returnColIdx}{: Numeric index of columns to return. Default 1:15}
}
\description{
Loads chimeric output file from the STAR aligner and returns a list containing
three items (a data table, alignment stats and command line).
}
\details{
:

Reads in a text or gzipped chimeric output file generated by the STAR aligner. Function
automatically detects if the last two lines contains meta-data (produced from STAR 2.7)
onwards.

Returns a list of containing three items: (1) data_set (2) alignmentStats and (3) commandLine.

The column names of data_set are defined as
c("chromDonor","startDonor","strandDonor", "chromAcceptor",
"startAcceptor","strandAcceptor","JuncType", "RepeatLength_L",
"RepeatLength_R",  "ReadName","FirstBase_1stSeq","CIGAR_1stSeg",
"FirstBase_2ndSeq","CIGAR_2ndSeg", "Multimapping")

If ID_index is set to a value greater than 0 then an additional column called
"DataSet" is created.

Columns can be subsetted by defining returnColIdx with an integer value that correspond
to order of column names listed above.
}
