% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotCellBin2D}
\alias{plotCellBin2D}
\title{Plot cell density as 2D histogram}
\usage{
plotCellBin2D(
  sfe,
  sample_id = "all",
  bins = 200,
  binwidth = NULL,
  hex = FALSE,
  ncol = NULL,
  bbox = NULL
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{bins}{Number of bins. Can be a vector of length 2 to specify for x and
y axes separately.}

\item{binwidth}{Width of bins, passed to \code{\link{geom_bin2d}} or
\code{\link{geom_hex}}.}

\item{hex}{Logical, whether to use hexagonal bins.}

\item{ncol}{Number of columns if plotting multiple features. Defaults to
\code{NULL}, which means using the same logic as \code{facet_wrap}, which
is used by \code{patchwork}'s \code{\link{wrap_plots}} by default.}

\item{bbox}{A bounding box to specify a smaller region to plot, useful when
the dataset is large. Can be a named numeric vector with names "xmin",
"xmax", "ymin", and "ymax", in any order. If plotting multiple samples, it
should be a matrix with sample IDs as column names and "xmin", "ymin",
"xmax", and "ymax" as row names. If multiple samples are plotted but
\code{bbox} is a vector rather than a matrix, then the same bounding box
will be used for all samples. You may see points at the edge of the
geometries if the intersection between the bounding box and a geometry
happens to be a point there. If \code{NULL}, then the entire tissue is
plotted.}
}
\value{
A ggplot object.
}
\description{
This function plots cell density in histological space as 2D histograms,
especially helpful for larger smFISH-based datasets.
}
\examples{
library(SFEData)
sfe <- HeNSCLCData()
plotCellBin2D(sfe)
}
\concept{Spatial plotting}
