% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmat_utils.R
\name{computeVmat}
\alias{computeVmat}
\title{A function to compute Vplot matrix}
\usage{
computeVmat(
  bam_granges,
  granges,
  cores = 1,
  xlims = c(-250, 250),
  ylims = c(50, 300)
)
}
\arguments{
\item{bam_granges}{GRanges, paired-end fragments}

\item{granges}{GRanges, regions to map the fragments onto}

\item{cores}{Integer, nb of threads to parallelize fragments subsetting}

\item{xlims}{The x limits of the computed Vmat}

\item{ylims}{The y limits of the computed Vmat}
}
\value{
A table object
}
\description{
This function computes the underlying matrix shown as a heatmap
in Vplots. For each pair of coordinates (x: distance from fragment
midpoint to center of GRanges of interest; y: fragment size), the 
function computes how many fragments there are.
}
\examples{
data(bam_test)
data(ce11_all_REs)
Vmat <- computeVmat(bam_test, ce11_all_REs)
dim(Vmat)
Vmat[seq(1,5), seq(1,10)]
}
