% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bamutils.R
\name{importPEBamFiles}
\alias{importPEBamFiles}
\title{A function to import paired end bam files as GRanges}
\usage{
importPEBamFiles(
  files,
  genome = NULL,
  where = NULL,
  max_insert_size = 1000,
  shift_ATAC_fragments = FALSE,
  cores = 10,
  verbose = TRUE
)
}
\arguments{
\item{files}{character vector, each element of the vector is the path 
of an individual .bam file.}

\item{genome}{character, genome ID (e.g. "sacCer3", "ce11", "dm6", 
"mm10" or "hg38").}

\item{where}{GRanges, only import the fragments mapping to the 
input GRanges (can fasten the import process a lot).}

\item{max_insert_size}{Integer, filter out fragments larger 
than this size.}

\item{shift_ATAC_fragments}{Boolean, if the fragments come 
from ATAC-seq, one might want to shift the extremities by +5 / -4 bp.}

\item{cores}{Integer, number of cores to use when indexing bam files}

\item{verbose}{Boolean}
}
\value{
A GRanges object containing fragments from the input .bam file.
}
\description{
This function takes bam file paths and read them into GRanges 
objects.
Note: Can be quite lengthy for .bam files with 5+ millions fragments.
}
\examples{
bamfile <- system.file("extdata", "ex1.bam", package = "Rsamtools")
fragments <- importPEBamFiles(
    bamfile, 
    shift_ATAC_fragments = TRUE
)
fragments
}
