% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_slot_experiment.R
\name{selectModelIds}
\alias{selectModelIds}
\alias{selectModelIds,XevaSet-method}
\title{To select model IDs based on drug name and/or tissue type.}
\usage{
selectModelIds(object, drug = NULL, drug.match.exact = TRUE, tissue = NULL)

\S4method{selectModelIds}{XevaSet}(object, drug = NULL, drug.match.exact = TRUE, tissue = NULL)
}
\arguments{
\item{object}{The \code{XevaSet}.}

\item{drug}{Name of the \code{drug}.}

\item{drug.match.exact}{Default \code{TRUE}.}

\item{tissue}{Tumor type. Default \code{NULL}.}
}
\value{
A \code{vector} with the matched \code{model.id}s.
}
\description{
To select model IDs based on drug name and/or tissue type.
}
\examples{
data(brca)
df = selectModelIds(brca, drug="trastuzumab", drug.match.exact=TRUE, tissue="BRCA")
head(df)
df2 = selectModelIds(brca, drug="trastuzumab", drug.match.exact=FALSE)
head(df2)

}
