% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histPvalue.R
\name{histPvalue}
\alias{histPvalue}
\alias{histPvalue,limma-method}
\alias{histPvalue,MArrayLM-method}
\alias{histPvalue,numeric-method}
\title{Plot the Distribution of P Values}
\usage{
histPvalue(object, ...)

\S4method{histPvalue}{limma}(object, ...)

\S4method{histPvalue}{MArrayLM}(object, coef, ...)

\S4method{histPvalue}{numeric}(object, ...)
}
\arguments{
\item{object}{either a numeric vector of p-values,
or an object of class \code{tTest}, \code{limma} or \code{MArrayLM}}

\item{...}{further arguments passed to the method}

\item{coef}{index of the coefficient for which the p values should be plotted;
only applies to the MArrayLM method}
}
\value{
The histogram is displayed on the current device.
}
\description{
This function displays the distribution of the p values using
a histogram; the horizontal line represents a uniform distribution 
based on the p value distribution between 0.5 and 1. This represents
the hypothetical p value distribution arising just by chance.
This uniform distribution is used to estimate the proportion of differentially
expressed genes.
}
\examples{
if (require(ALL)){
 data(ALL, package = "ALL")
 ALL <- addGeneInfo(ALL)
 ALL$BTtype <- as.factor(substr(ALL$BT,0,1))
 tTestResult <- tTest(ALL, "BTtype")
 histPvalue(tTestResult[,"p"], addLegend = TRUE)
 propDEgenesRes <- propDEgenes(tTestResult[,"p"])  
}
}
\references{
Goehlmann, H. and W. Talloen (2009). Gene Expression Studies Using Affymetrix
 Microarrays, Chapman \& Hall/CRC, p. 253.
}
\author{
Willem Talloen and Tobias Verbeke
}
\keyword{dplot}
