% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adductSpecGen.R
\name{adductSpecGen}
\alias{adductSpecGen}
\title{Constructor of AdductSpec object deconvolute spectra 
MS2 and MS1 levels}
\usage{
adductSpecGen(mzXmlDir=NULL, runOrder=NULL, nCores=NULL,
intStdMass=834.77692,intStdPeakList=c(290.21, 403.30, 516.38,
587.42,849.40, 884.92, 958.46, 993.97,1050.52, 1107.06, 1209.73,
1337.79,1465.85),TICfilter=10000, DNF=2, minInt=300,
minPeaks=5,intStd_MaxMedRtDrift=360, intStd_MaxPpmDev=200,minSpecEx=40,
outputPlotDir=NULL)
}
\arguments{
\item{mzXmlDir}{character a full path to a directory containing 
either .mzXML or .mzML data}

\item{runOrder}{character a full path to a csv file specifying the 
runorder for each of the files
the first column must contain the precise file name and the second 
column an integer representing the precise run order.}

\item{nCores}{numeric the number of cores to use for parallel computation. 
The default is to 1 core}

\item{intStdMass}{numeric vector of the mass of the internal standard. 
Default is the mass of}

\item{intStdPeakList}{numeric vector of masses for the internal 
standard peaks}

\item{TICfilter}{numeric minimimum total ion current of an MS/MS scan.
Any MS/MS scan below this value will be filtered out (default=0).}

\item{DNF}{dynamic noise filter minimum signal to noise threshold 
(default = 2), calculated as the ratio between the linear model predicted 
intensity value and the actual intensity.}

\item{minInt}{numeric minimum intensity value}

\item{minPeaks}{minimum number of signal peaks following dynamic 
noise filtration (default = 5).}

\item{intStd_MaxMedRtDrift}{numeric the maximum retention time drift 
window (in seconds) to identify internal standard MS/MS spectrum scans
(default = 600).}

\item{intStd_MaxPpmDev}{numeric the maximum mass accuracy window (in ppm).
to identify internal standard MS/MS spectrum scans (default = 200 ppm).}

\item{minSpecEx}{numeric the minimum percentage of the total ion 
current explained
by the internal standard fragments (default = 40). Sometime spectra are not
identified due to this cutoff being set too high. If unexpected datapoints
have been interpolated then reduce this value.}

\item{outputPlotDir}{character string for the output directory for plots, 
default is working directory.}
}
\value{
AdductSpec object
}
\description{
reads mzXML files from a directory extracts metadata info,
groups ion signals with \code{\link{signalGrouping}}, filters noise 
dynamically
\code{\link{dynamicNoiseFilter}} and identifies precursor ion charge state,
by isotopic pattern.
}

