% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakIdQuant_newMethod.R
\name{peakIdQuant_newMethod}
\alias{peakIdQuant_newMethod}
\title{Adduct Peak quant}
\usage{
peakIdQuant_newMethod(mzTmp = NULL, rtTmp = NULL, 
peakRangeRtSub = NULL, rtDevModel = NULL, isoPat = NULL,
isoPatPred = NULL, minSimScore = 0.96, maxPpm = 4, 
gaussAlpha = 16, spikeScans = 2, minPeakHeight = 5000, 
maxRtDrift = 20, showPlots = FALSE, 
isoWindow = 10, maxGapMs1Scan = 5, intMaxPeak = FALSE)
}
\arguments{
\item{mzTmp}{expected mass to charge of target}

\item{rtTmp}{expected retention time (in minutes) of target}

\item{peakRangeRtSub}{matrix MS1 scans covering entire chromatographic range
within which to identify peaks of interest. Contains the following 
three columns
column 1 = mass, column 2 = intensity, column 3 = retention time, 
column 4 = scan number.}

\item{rtDevModel}{loess retention time deviation model for the file.}

\item{isoPat}{named numeric containing the expected mass differences 
between isotopes for the peptide
of interest.}

\item{isoPatPred}{matrix output from the \code{\link{IsotopicDistribution}}
function with additional 'id' column.}

\item{minSimScore}{numeric minimum dot product score for consideration 
(must be between 0-1, default = 0.96).}

\item{maxPpm}{numeric ppm value for EIC extraction and integration.}

\item{gaussAlpha}{numeric alpha value for \code{\link{smth.gaussian}} 
of smoother package. If supplied gaussian smoothing will be performed 
(suggested value = 16).}

\item{spikeScans}{numeric number of scans that constitute a spike.}

\item{minPeakHeight}{numeric minimum peak height, default 5000}

\item{maxRtDrift}{numeric maximum retention time drift, default 20 secs}

\item{showPlots}{boolean for whether plots should be produced}

\item{isoWindow}{numeric isowindow size, default 10}

\item{maxGapMs1Scan}{maximum MS1 scan gap, default 5}

\item{intMaxPeak}{boolean integrate maximum peak}
}
\value{
list
}
\description{
peak must be at least 50 percent resolved from overlapping peaks. 
i.e. the peaks trough
must be at least 50 percent of the peak apex intensity for the peak to be 
considered sufficiently resolved.
}
