% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveBumpyDataFrameMatrix.R
\name{saveObject,BumpyDataFrameMatrix-method}
\alias{saveObject,BumpyDataFrameMatrix-method}
\alias{stageObject,BumpyDataFrameMatrix-method}
\title{Save a BumpyDataFrameMatrix to disk}
\usage{
\S4method{saveObject}{BumpyDataFrameMatrix}(x, path, ...)
}
\arguments{
\item{x}{A BumpyDataFrameMatrix object.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments to pass to specific methods.}
}
\value{
\code{x} is saved into \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save a \linkS4class{BumpyDataFrameMatrix} to its on-disk representation.
}
\examples{
# Mocking up a BumpyMatrix.
library(BumpyMatrix)
library(S4Vectors)
df <- DataFrame(x=runif(100), y=runif(100))
f <- factor(sample(letters[1:20], nrow(df), replace=TRUE), letters[1:20])
out <- S4Vectors::split(df, f)
mat <- BumpyMatrix(out, c(5, 4))

# Saving it:
tmp <- tempfile()
saveObject(mat, tmp)

}
\author{
Aaron Lun
}
