% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_general.R
\name{cigarsToEvents}
\alias{cigarsToEvents}
\title{Transform extended CIGAR strings into GRanges.}
\usage{
cigarsToEvents(
  cigars,
  aln_pos_start,
  query_seq,
  ref,
  read_id,
  mapq,
  seqnames,
  strands,
  counts
)
}
\arguments{
\item{cigars}{(character) Extended CIGARS.}

\item{aln_pos_start}{(integer) Pos of CIGARS.}

\item{query_seq}{(character) Aligned query sequences.}

\item{ref}{(character) Reference sequences used for alignment.}

\item{read_id}{(numeric) Read id for assignment for each of the CIGARS.}

\item{mapq}{(numeric) Maping scores.}

\item{seqnames}{(character) Names of the sequences, potentially ids of
the reference sequences.}

\item{strands}{(character) Strands to assign.}

\item{counts}{(integer) Vector of cigar counts, if data collapsed.}
}
\value{
(\code{\link[GenomicRanges]{GRanges}}) Same as events.
}
\description{
Transform extended CIGAR strings into \code{\link[GenomicRanges]{GRanges}} representation
with events of deletions, insertions and mismatches.
}
