% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbEstDisp.R
\name{bbEstDisp}
\alias{bbEstDisp}
\title{Simple line-search estimator for dispersion of a beta binomial}
\usage{
bbEstDisp(success, size, weights = 1, x, beta, minDisp, maxDisp, se = FALSE)
}
\arguments{
\item{success}{the observed successes (a matrix)}

\item{size}{the total trials (a matrix)}

\item{weights}{the weights (1 or a matrix)}

\item{x}{the design matrix, as many rows as columns of \code{success} and \code{size}}

\item{beta}{a matrix of MLE coefficients, as many rows as \code{success} and \code{size}}

\item{minDisp}{the minimum dispersion value}

\item{maxDisp}{the maximum dispersion value}

\item{se}{logical, whether to return standard error estimate on the log of
the dispersion (theta). Warning: the standard error estimates are not
reliable at the boundary (log of minDisp and maxDisp), and should be
interpreted with caution!}
}
\value{
a vector of estimated dispersions (theta). if \code{se=TRUE} a matrix
with columns: the vector of estimated dispersions and the standard
errors for the log of the estimated dispersions
}
\description{
Uses R's \code{optimize} function to find the maximum likelihood
estimate of dispersion for a beta binomial distribution
(\code{theta} for the \code{dbetabinom} function in the
emdbook package). The counts, size, and beta are matrices,
such that each row could be treated as a beta-binomial GLM
problem.
}
\examples{

library(emdbook)
n <- 100
m <- 100
size <- matrix(rnbinom(n*m, mu=100, size=10),ncol=m)
success <- matrix(rbetabinom(n*m, prob=.5, size=size, theta=100),ncol=m)
x <- matrix(rep(1,m),ncol=1)
beta <- matrix(rep(0,n),ncol=1)
theta <- bbEstDisp(success=success, size=size, x=x, beta=beta, minDisp=1, maxDisp=500)
summary(theta)

# with standard error estimates on log of dispersion
fit <- bbEstDisp(success=success, size=size, x=x, beta=beta, minDisp=1, maxDisp=500, se=TRUE)
plot(fit[1:20,"theta"], ylim=c(0,500), ylab="theta-hat")
log.theta <- log(fit[1:20,"theta"])
log.theta.se <- fit[1:20,"se"]
segments(1:20, exp(log.theta - 2 * log.theta.se),
         1:20, exp(log.theta + 2 * log.theta.se))
abline(h=100,col="red")


}
