% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidenceToSAINTqFormat.R
\name{artmsEvidenceToSAINTq}
\alias{artmsEvidenceToSAINTq}
\title{MaxQuant evidence file to SAINTq format}
\usage{
artmsEvidenceToSAINTq(
  evidence_file,
  keys_file,
  output_dir = "artms_saintq",
  sc_option = c("all", "msspc"),
  fractions = FALSE,
  quant_variable = c("msint", "msspc"),
  verbose = TRUE
)
}
\arguments{
\item{evidence_file}{(char or data.frame) The evidence file path and name,
or data.frame}

\item{keys_file}{(char) Keys file with a SAINT column specifying
test (\code{T}) and control (\code{C}) conditions}

\item{output_dir}{(char) New directory to create and save files.
Default is current directory (recommended to provide a new folder name).}

\item{sc_option}{(char). Filter peptides with spectral counts only.
Two options:
\itemize{
\item \code{msspc}: use only peptides with spectral_counts
\item \code{all} (default): all peptides detected (including the one resulting from
the MaxQuant 'Match between run' algorithm)
}}

\item{fractions}{(logical) \code{TRUE} for 2D proteomics (fractions).
Default: \code{FALSE}}

\item{quant_variable}{(char) Select the quantitative variable.
Two options available:
\itemize{
\item \code{msint}: MS Intensity (default)
\item \code{msspc}: MS.MS.count (Spectral Counts)
}}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
The input files requires to run SAINTq
}
\description{
Converts the MaxQuant evidence file to the required files
by SAINTq. The user can choose to use either peptides with \verb{spectral counts}
(use \code{msspc}) or the all the peptides (use \code{all}) for the analysis.
The quantitative can be also chosen (either MS Intensity or Spectral Counts)
}
\details{
After running the script, the new specified folder should contain
the folling files:
\itemize{
\item saintq-config-peptides
\item saintq-config-proteins
\item saintq_input_peptides.txt
\item saintq_input_proteins.txt
}

Then \code{cd} into the new folder and run either of the following two options
(assuming that \code{saintq} is installed in your linux/unix/mac os x system):

\verb{> saintq config-saintq-peptides}

or

\verb{> saintq config-saintq-proteins}
}
\examples{
# Testing that the files cannot be empty
artmsEvidenceToSAINTq   (evidence_file = NULL, 
                                   keys_file = NULL, 
                                   output_dir = NULL)
}
\keyword{APMS}
\keyword{SAINT,}
\keyword{SAINTq,}
