% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstats_functions.R
\name{artmsResultsWide}
\alias{artmsResultsWide}
\title{Reshape the MSstats results file from long to wide format}
\usage{
artmsResultsWide(
  results_msstats,
  output_file = NULL,
  select_pvalues = c("adjpvalue", "pvalue"),
  species,
  verbose = TRUE
)
}
\arguments{
\item{results_msstats}{(char) Input file name and location
(MSstats \code{results.txt} file)}

\item{output_file}{(char) Output file name and location
(e.g. \code{results-wide.txt}). If \code{NULL} (default) returns an
R object (data.frame)}

\item{select_pvalues}{(char) Either
\itemize{
\item \code{pvalue} or
\item \code{adjpvalue} (default)
}}

\item{species}{(char) Specie name for annotation purposes.
Check \code{?artmsMapUniprot2Entrez} to find out more about the
supported species (e.g \code{species = "human"})}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
(output file tab delimited) reshaped file with unique protein ids
and as many columns log2fc and adj.pvalues as comparisons available
}
\description{
Converts the normal MSStats results.txt file into "wide" format
where each row represents a unique protein's results, and each column
represents the comparison made by MSStats. The fold change and p-value
of each comparison will be its own column.
}
\examples{
ph_results_wide <- artmsResultsWide(
                         results_msstats = artms_data_ph_msstats_results,
                         output_file = NULL,
                         species = "human")
}
\keyword{msstats,}
\keyword{reshape}
\keyword{results,}
\keyword{wide,}
