% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSstats_functions.R
\name{artmsSpectralCounts}
\alias{artmsSpectralCounts}
\title{Outputs the spectral counts from the MaxQuant evidence file.}
\usage{
artmsSpectralCounts(
  evidence_file,
  keys_file,
  output_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{evidence_file}{(char) Maxquant evidence file or data object}

\item{keys_file}{(char) Keys file with the experimental design or data object}

\item{output_file}{(char) Output file name (add \code{.txt} extension).
If \code{NULL} (default) it returns a data.frame object}

\item{verbose}{(logical) \code{TRUE} (default) shows function messages}
}
\value{
A txt file with biological replicates, protein id, and spectral
count columns
}
\description{
Outputs the spectral counts from the MaxQuant evidence file.
}
\examples{
summary_spectral_counts <- artmsSpectralCounts(
                                 evidence_file = artms_data_ph_evidence,
                                 keys_file = artms_data_ph_keys)
}
\keyword{evidence}
\keyword{spectral_counts,}
