% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/23_impute.R
\name{plot_sample_nas}
\alias{plot_sample_nas}
\alias{plot_subgroup_nas}
\alias{plot_detections}
\alias{plot_summarized_detections}
\title{Plot (summarized) detections}
\usage{
plot_sample_nas(...)

plot_subgroup_nas(...)

plot_detections(
  object,
  by = "subgroup",
  fill = by,
  palette = make_svar_palette(object, fill),
  axis.text.y = element_blank()
)

plot_summarized_detections(
  object,
  by = "subgroup",
  fill = by,
  palette = NULL,
  na_imputes = TRUE
)
}
\arguments{
\item{...}{used to maintain deprecated functions}

\item{object}{SummarizedExperiment}

\item{by}{svar (string)}

\item{fill}{svar (string)}

\item{palette}{color vector (names = levels, values = colors)}

\item{axis.text.y}{passed to ggplot2::theme}

\item{na_imputes}{TRUE or FALSE}
}
\value{
ggplot object
}
\description{
\code{plot_detections} plots the detection structure at feature/sample resolution.
It shows systematic/random NAs (white), full detection (bright color) and imputations (light color).
}
\details{
\code{plot_summarized_detections} plots the detection structure at featuregroup/samplegroup resolution.
It shows full detection and random NAs (bright color) and imputations (light color).
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
plot_detections(object)
plot_detections(impute(object))
plot_summarized_detections(object)
plot_summarized_detections(impute(object))

subgroups <- sprintf('\%s_STD', c('E00','E01','E02','E05','E15','E30','M00'))
file <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file, subgroups = subgroups)
plot_summarized_detections(object)
plot_summarized_detections(object, 'subgroup')
plot_detections(object)
plot_detections(object, 'subgroup')
}
