% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pctOverlap.R
\name{pctOverlap}
\alias{pctOverlap}
\title{calculate percent overlap between two GRanges objects}
\usage{
pctOverlap(tx1, tx2)
}
\arguments{
\item{tx1}{GRanges object}

\item{tx2}{GRanges object}
}
\value{
percent overlap between \code{tx1} and \code{tx2}, as defined by the 
  ratio of the intersection of \code{tx1} and \code{tx2} to the union of 
  \code{tx1} and \code{tx2}.
}
\description{
calculate percent overlap between two GRanges objects
}
\details{
In the ballgown context, \code{tx1} and \code{tx2} are two
  transcripts, each represented by GRanges objects whose ranges represent the
  exons comprising the transcripts.  The percent overlap is the number of 
  nucleotides falling within both transcripts divided by the number of 
  nucleotides falling within either transcript.  Useful as a measure of 
  transcript closeness (as it is essentially Jaccard distance).
}
\examples{
data(bg)
gtfPath = system.file('extdata', 'annot.gtf.gz', package='ballgown')
annot_grl = gffReadGR(gtfPath, splitByTranscript=TRUE)
pctOverlap(structure(bg)$trans[[2]], annot_grl[[369]]) #79.9\%
}
\author{
Alyssa Frazee
}
