% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTranscripts.R
\name{compareTranscripts}
\alias{compareTranscripts}
\title{compare alternatively-spliced transcripts}
\usage{
compareTranscripts(query, subject)
}
\arguments{
\item{query}{a GRangesList of transcripts}

\item{subject}{a GRangesList of transcripts}
}
\value{
a \code{tibble} object with the following columns:

Remark: two exons, one each from query and subject transcript are defined to be equivalent if one of 
the exons fully covers the another exon. 

\itemize{
    \item alternativeFirstExon: FALSE if query transcript and subject transcript have equivalent
    first exon. TRUE otherwise. 
    \item alternativeTSS: +k if the query initiates the transcription k sites earlier 
    than the subject transcript, -k if the query initiates the transcription k sites later 
    than the subject transcript. 
    \item internalFirstExon.query: TRUE if the first exon of the query transcript is equivalent to
    one of the exon of the subject transcript (except the first exon). FALSE otherwise. 
    \item internalFirstExon.subject: TRUE if the first exon of the subject transcript is equivalent to
    one of the exon of the query transcript (except the first exon). FALSE otherwise. 
    \item alternativeLastExon: FALSE if query transcript and subject transcript have equivalent last
    exon. TRUE otherwise. 
    \item alternativeTES: +k if the query transcript ends the transcription k sites later than the 
    subject transcript, -k if the query transcript ends the transcription k sites earlier than the 
    subject transcript. 
    \item internalLastExon.query: TRUE if the last exon of the query transcript is equivalent to one 
    of the exon in the subject transcript (except the last exon). FALSE otherwise. 
    \item internalLastExon.subject: TRUE if the last exon of the subject transcript is equivalent to 
    one of the exon in the query transcript (except the last exon). FALSE otherwise. 
    \item intronRetention.subject: k if there is/are k intron(s) in the subject transcript relative to the 
    query transcript. 
    \item intronRetention.query: k if there is/are k intron(s) in the query transcript relative to the 
    subject transcript. 
    \item exonSkipping.query: k if there is/are k exon(s) in the subject transcript (except the first and last) not in the
    query transcript. 
    \item exonSkipping.subject: k if there is/are k exon(s) in the query transcript (except the first and last) not in the 
    subject transcript. 
    \item exon5prime (splicing): k if there is/are k equivalent exon(s) having different 5' start site (except the 5' start site of first exon).
    \item exon3prime (splicing): k if there is/are k equivalent exon(s) having different 3' end site (except the 3' end site of the last exon).
}
}
\description{
compare alternatively-spliced transcripts
}
\details{
This function compares two alternatively-spliced transcripts and returns 
a \code{tibble} object that determines the type of the alternative splicing between 
the query and the subject transcript. Alternative splicing includes exons skipping, 
intron retention, alternative 5' exon start site, alternative 3' exon end site, alternative
first exon, alternative last exon, alternative transcription start site (TSS), 
alternative transcription end site (TES), internal first exon, internal last exon, or a 
mixed combination of them.
}
\examples{
query <- readRDS(system.file("extdata", 
    "annotateSpliceOverlapByDist_testQuery.rds",
    package = "bambu"))
subject <- readRDS(system.file("extdata", 
    "annotateSpliceOverlapByDist_testSubject.rds",
    package = "bambu"))
compareTranscriptsTable <- compareTranscripts(query, subject)

compareTranscriptsTable
}
\seealso{
\code{Value} for more details about each of the alternative splicing events.
}
