% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzzCountSignals.R
\docType{class}
\name{CountSignals-class}
\alias{CountSignals}
\alias{CountSignals-class}
\alias{[,CountSignals,ANY-method}
\alias{alignSignals}
\alias{alignSignals,CountSignals-method}
\alias{as.list}
\alias{as.list,CountSignals-method}
\alias{length}
\alias{length,CountSignals-method}
\alias{width}
\alias{width,CountSignals-method}
\title{Container for count signals}
\usage{
\S4method{length}{CountSignals}(x)

\S4method{width}{CountSignals}(x)

\S4method{[}{CountSignals,ANY}(x, i, drop = TRUE)

\S4method{as.list}{CountSignals}(x)

\S4method{alignSignals}{CountSignals}(x)
}
\arguments{
\item{x}{A CountSignals object}

\item{i}{Index for subsetting. It can be a single index as well as
a vector of indices.}

\item{drop}{In case \code{i} is a vector of length 1, after subsetting, 
collapse the CountSignal object to a single signal or not.}
}
\value{
return values are described in the Methods section.
}
\description{
This s4 class is a tiny wrapper around a normal list (stored in the
\code{signals} slot) and it is the output of the methods in the
bamsignals package. 
Among other things the container provides an accessor method, 
that returns single signals as vectors and matrices, and the 
methods \code{as.list} and \code{alignSignals}, that convert the 
container to a list or an array/matrix respectively. A CountSignals
object is read-only, i.e. it cannot be modified.
}
\section{Methods (by generic)}{
\itemize{
\item \code{length}: Number of contained signals

\item \code{width}: Width of each signal. If the CountSignals
object \code{csig} is strand-specific then
\code{width(csig)[i] == ncol(csig[i])}, otherwise 
\code{width(csig)[i] = length(csig[i])}.

\item \code{[}: Access single signals or subset the CountSignals 
object.
If \code{i} is a single index and \code{drop==TRUE} then the accessor returns
a single signal. If \code{x} is strand-specific then a single signal is a 
matrix with two rows, the first for the sense, the second for the antisense 
strand. Otherwise a signle signal is simply a vector of integers. If \code{i}
is a vector of length different than 1, then the acessor returns a subset of 
the CountSignals object. Invalid indices result into errors.

\item \code{as.list}: Converts the container to a list \code{l} such that
\code{l[[i]]} is the i-th signal.

\item \code{alignSignals}: Convert to a matrix or to an array. This is only
possible if all signals have the same width \code{w}. If the CountSignals
object \code{csig} is strand-specific, the result is an array of dimensions 
\code{[2, w, length(csig)]}, otherwise it will be a matrix of dimensions
\code{[w, length(csig)]}.
}}
\section{Slots}{

\describe{
\item{\code{ss}}{A single boolean value indicating whether all
signals are strand-specific or not}

\item{\code{signals}}{A list of integer vectors (if \code{ss==TRUE}) or of integer
matrices, representing each signal}
}}
\examples{
#get a CountSignals object
library(GenomicRanges)
bampath <- 
system.file("extdata", "randomBam.bam", package="bamsignals")
genes <- 
get(load(system.file("extdata", "randomAnnot.Rdata", package="bamsignals")))
csig <- bamProfile(bampath, genes, ss=TRUE)

#show it
show(csig)

#number of contained signals
len <- length(csig)

#width of each signal
w <- width(csig)

#get one element as a vector (or matrix)
v <- csig[1]

#use as if it was a list
tot_per_sig <- sapply(csig, sum)

#convert to a list
siglist <- as.list(csig)

#get regions and signals of the same width
proms <- promoters(genes, upstream=150, downstream=150)
csig <- bamCoverage(bampath, proms)

#convert to matrix
mat <- alignSignals(csig)
}
\seealso{
\code{\link{bamsignals-methods}} for the functions that produce 
this object
}

