% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarcodeSignif.R
\name{plotBarcodeMA}
\alias{plotBarcodeMA}
\title{Plot Barcodes catogorized by significant change using a dot plot}
\usage{
plotBarcodeMA(barbieQ)
}
\arguments{
\item{barbieQ}{A \code{barbieQ} object created by the \link{createBarbieQ} function,
updated with Barcode test results by calling the \link{testBarcodeSignif} function.}
}
\value{
A \code{ggplot} S3 class object displaying the significance level
against other properties of Barcodes in a dot plot.
}
\description{
\code{plotBarcodeMA()} use a dot plot to visualize the variation and mean of
each Barcode in differential proportion or occurrence,
as determined by the \link{testBarcodeSignif} function.
}
\examples{
Block <- c(1, 1, 2, 3, 3, 4, 1, 1, 2, 3, 3, 4)
Treat <- factor(rep(c('ctrl', 'drug'), each = 6))
Time <- rep(rep(seq_len(2), each = 3), 2)
nbarcodes <- 50
nsamples <- 12
count <- abs(matrix(rnorm(nbarcodes * nsamples), nbarcodes, nsamples))
rownames(count) <- paste0('Barcode', seq_len(nbarcodes))
barbieQ <- createBarbieQ(count, data.frame(Treat = Treat, Time = Time))
testBB <- testBarcodeSignif(barbieQ, sampleGroup = 'Treat')
plotBarcodeMA(barbieQ = testBB)
}
