% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phantomJS.R
\name{widgetThumbnail}
\alias{widgetThumbnail}
\title{Capture html output widget as .png in R}
\usage{
widgetThumbnail(p, thumbName, width = 1024, height = 1024)
}
\arguments{
\item{p}{is the html widget}

\item{thumbName}{is the name of the new png file}

\item{width}{1024}

\item{height}{1024}
}
\value{
3 files .html, .js and .png
}
\description{
Capture html output widget as .png in R
}
\examples{
How <- "runManually"
\dontrun{
# Load package
library(networkD3)
library(htmlwidgets)
# Create fake data
src <- c("A", "A", "A", "A", "B", "B", "C", "C", "D")
target <- c("B", "C", "D", "J", "E", "F", "G", "H", "I")
networkData <- data.frame(src, target)
# Plot
plot = simpleNetwork(networkData)
# Save html as png
widgetThumbnail(p = plot, thumbName = "plot", width = 1024, height = 1024)
}
}
