% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBSseq.R
\name{makeBSseq}
\alias{makeBSseq}
\title{Make an in-memory bsseq object from a biscuit BED}
\usage{
makeBSseq(tbl, params, simplify = FALSE, verbose = FALSE)
}
\arguments{
\item{tbl}{A tibble (from read_tsv) or a data.table (from fread)}

\item{params}{Parameters from checkBiscuitBED}

\item{simplify}{Simplify sample names by dropping .foo.bar.hg19? (or
similar) (DEFAULT: FALSE)}

\item{verbose}{Print extra statements? (DEFAULT: FALSE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     An in-memory bsseq object
}\if{html}{\out{</div>}}
}
\description{
Beware that any reasonably large BED files may not fit into memory!
}
\examples{

  library(data.table)
  library(R.utils)

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  params <- checkBiscuitBED(BEDfile = orig_bed, VCFfile = orig_vcf,
                            merged = FALSE, how = "data.table")

  select <- grep("\\\\.context", params$colNames, invert=TRUE)
  tbl <- fread(gunzip(params$tbx$path, remove = FALSE), sep="\t", sep2=",",
               fill=TRUE, na.strings=".", select=select)
  unzippedName <- sub("\\\\.gz$", "", params$tbx$path)
  if (file.exists(unzippedName)) {
    file.remove(unzippedName)
  }
  if (params$hasHeader == FALSE) names(tbl) <- params$colNames[select]
  names(tbl) <- sub("^#", "", names(tbl))
  
  tbl <- tbl[rowSums(is.na(tbl)) == 0, ]
  bsseq <- makeBSseq(tbl = tbl, params = params)

}
