% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blase_data_class.R
\docType{class}
\name{BlaseData-class}
\alias{BlaseData-class}
\alias{BlaseData}
\title{Blase Data Object}
\value{
A \link{BlaseData} object
}
\description{
For creation details, see \code{\link[=as.BlaseData]{as.BlaseData()}}
}
\section{Slots}{

\describe{
\item{\code{pseudobulk_bins}}{list of \link{data.frame}s. Each item is a normalised
count matrix representing a bin, where a column is a cell in the bin
and each row is a gene.}

\item{\code{bins}}{list. A list of bin names for each timepoint.}

\item{\code{genes}}{list. A list of the genes selected for
discriminating timepoints.}
}}

\examples{
counts <- matrix(rpois(100, lambda = 10), ncol = 10, nrow = 10)
sce <- SingleCellExperiment::SingleCellExperiment(
    assays = list(normcounts = counts)
)
sce$pseudotime <- seq_len(10) - 1
data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 3)
genes(data) <- as.character(seq_len(10))

genes(data)
}
\concept{blase-object}
