% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{evaluate_top_n_genes}
\alias{evaluate_top_n_genes}
\title{Evaluate Top Genes}
\usage{
evaluate_top_n_genes(blase_data, n_genes_to_plot = 16, plot_columns = 4)
}
\arguments{
\item{blase_data}{The \link{BlaseData} to get bins and expression from.}

\item{n_genes_to_plot}{Integer. The number of genes to plot.}

\item{plot_columns}{Integer. The number of columns to plot the grid with.
Best as a divisor of \code{n_genes_to_plot}.}
}
\value{
A \link[ggplot2:ggplot2-package]{ggplot2::ggplot2} plot showing the normalised expression of the top genes
over pseudotime bins.
}
\description{
Shows plots over bins of expression of the top n genes.
This is designed to help identify if you have selected
genes that vary over the pseudotime you have chosen
bins to exist over. Uses the normcounts of the SCE.
}
\examples{
ncells <- 70
ngenes <- 100
counts_matrix <- matrix(
    c(seq_len(3500) / 10, seq_len(3500) / 5),
    ncol = ncells,
    nrow = ngenes
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    normcounts = counts_matrix, logcounts = log(counts_matrix)
))
colnames(sce) <- paste0("cell", seq_len(ncells))
rownames(sce) <- paste0("gene", seq_len(ngenes))
sce$cell_type <- c(
    rep("celltype_1", ncells / 2),
    rep("celltype_2", ncells / 2)
)

sce$pseudotime <- seq_len(ncells) - 1
genelist <- rownames(sce)

# Evaluating created BlaseData
blase_data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 10)
genes(blase_data) <- genelist[1:20]

# Check gene expression over pseudotime
evaluate_top_n_genes(blase_data)
}
\concept{tuning}
