% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{dummyCNOlist}
\alias{dummyCNOlist}
\title{Create dummy CNOlist}
\usage{
dummyCNOlist(
  stimuli = NULL,
  inhibitors = NULL,
  maxStim = 0,
  maxInhibit = 0,
  signals = NULL
)
}
\arguments{
\item{stimuli}{Character vector of stimuli names.}

\item{inhibitors}{Character vector of inhibitors.}

\item{maxStim}{maximal number of stimulated genes for a single experiment}

\item{maxInhibit}{maximal number of inhibited genes for a single experiment}

\item{signals}{Optional character vector of signals. Signals are S-genes,
which can directly regulate E-genes. If left NULL, all stimuli and
inhibitors are defined as signals.}
}
\value{
CNOlist object
}
\description{
creates a general CNOlist object from meta information
}
\examples{
sifMatrix <- rbind(c("A", 1, "B"), c("A", 1, "C"), c("B", 1, "D"),
c("C", 1, "D"))
temp.file <- tempfile(pattern="interaction",fileext=".sif")
write.table(sifMatrix, file = temp.file, sep = "\t",
row.names = FALSE, col.names = FALSE,
quote = FALSE)
PKN <- CellNOptR::readSIF(temp.file)
CNOlist <- dummyCNOlist("A", c("B","C","D"), maxStim = 1, maxInhibit = 2,
signals = c("A", "B","C","D"))
}
\author{
Martin Pirkl
}
