% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{QueryBrendaBase}
\alias{QueryBrendaBase}
\title{Query for a specific enzyme.}
\usage{
QueryBrendaBase(brenda, EC, organisms = FALSE)
}
\arguments{
\item{brenda}{A \code{tibble} containing information from BRENDA.}

\item{EC}{A string of the EC number.}

\item{organisms}{A character vector indicating organisms to keep. Default is
FALSE, which would keep all organisms.}
}
\value{
A \code{brenda.entry} object.
}
\description{
Use a EC number to retrieve information from the BRENDA
\code{tibble} read in by \code{\link[=ReadBrenda]{ReadBrenda()}}.
}
\examples{
df <- ReadBrenda(system.file("extdata", "brenda_download_test.txt",
                          package = "brendaDb"))
brendaDb:::QueryBrendaBase(brenda = df, EC = "1.1.1.1",
                           organisms = "Homo sapiens")

}
\seealso{
\code{\link[=ReadBrenda]{ReadBrenda()}} \code{\link[=InitBrendaEntry]{InitBrendaEntry()}}
}
\keyword{internal}
