% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{calculateCellLineMean}
\alias{calculateCellLineMean}
\title{Calculate cell line mean}
\usage{
calculateCellLineMean(data, cellLine, metadata, rankPerCellLine)
}
\arguments{
\item{data}{Data table: comparison against CMap data}

\item{cellLine}{Character: perturbation identifiers as names and respective
cell lines as values}

\item{metadata}{Data table: \code{data} metadata}

\item{rankPerCellLine}{Boolean: rank results based on both individual cell
lines and mean scores across cell lines (\code{TRUE}) or based on mean
scores alone (\code{FALSE})? If \code{cellLineMean = FALSE}, individual
cell line conditions are always ranked.}
}
\value{
A list with two items:
\describe{
\item{\code{data}}{input \code{data} with extra rows containing cell line
  average scores (if calculated)}
\item{\code{rankingInfo}}{data table with ranking information}
\item{\code{metadata}}{metadata associated with output \code{data}, including
  for identifiers regarding mean cell line scores}
}
}
\description{
Calculate cell line mean
}
\keyword{internal}
