% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment.R
\name{binaryROC}
\alias{binaryROC}
\title{ROC curve for binary label prediction}
\usage{
binaryROC(
  scores,
  labels,
  cutoff = NULL,
  cut_direction = ">=",
  add_cut1 = TRUE,
  cutoff_point = 0.9
)
}
\arguments{
\item{scores}{Prediction score for each sample}

\item{labels}{True labels for each sample, e.g., from simulation}

\item{cutoff}{A vector of cutoffs; if NULL use all unique scores}

\item{cut_direction}{A string to compare with cutoff: >=, >, <=, <}

\item{add_cut1}{Logical value; if True, manually add a cutoff of 1}

\item{cutoff_point}{Numeric value; additional cutoff value}
}
\value{
A data.frame containing AUC and AUPRC at various cutoffs.
}
\description{
ROC curve for binary label prediction
}
\examples{
scores <- 1:10
labels <- c(0, 0, 0, 1, 0, 1, 0, 1, 1, 1)
binaryROC(scores, labels)

# Extra arguments. 
binaryROC(scores, labels, cutoff = seq(1, 10, by = 2))
binaryROC(scores, labels, cut_direction = ">")
binaryROC(scores, labels, add_cut1 = TRUE)

}
