% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{estkTW}
\alias{estkTW}
\title{Estimate the Number of Clusters (k) Using the Tracy-Widom Bound}
\usage{
estkTW(x)
}
\arguments{
\item{x}{A numeric matrix or data frame where rows are observations and
columns are variables.}
}
\value{
The estimated number of clusters (k).
}
\description{
This function estimates the number of clusters (k) in a dataset using the
Tracy-Widom distribution as a bound for the eigenvalues of the scaled data
covariance matrix.
}
\examples{
library(scater)
library(splatter)

sce <- splatSimulate(group.prob = rep(1, 5)/5, sparsify = FALSE, 
        batchCells=100, nGenes=1000, method = "groups", verbose = FALSE, 
        dropout.type = "experiment")
sce <- logNormCounts(sce)
logX <- as.matrix(logcounts(sce))
k <- estkTW(logX)

}
