% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{runKM}
\alias{runKM}
\title{Perform Consensus K-Means Clustering}
\usage{
runKM(
  logX,
  v,
  maxSets = 8,
  k,
  consMin = 0.75,
  kmNStart,
  kmMax = 1000,
  BPPARAM = bpparam()
)
}
\arguments{
\item{logX}{A (sparse or dense) numeric matrix representing the transpose of
a log-normalized gene expression matrix. Rows correspond to cells, and 
columns correspond to genes.}

\item{v}{A matrix of right singular vectors obtained from SVD of a distance
matrix derived from `logX`.}

\item{maxSets}{(Optional) The maximum number of sub-datasets used for
consensus clustering (default: \code{8}).}

\item{k}{(Optional) The number of clusters (cell groups) in the data. If not
provided, it is estimated using the Tracy-Widom Bound.}

\item{consMin}{(Optional) The low-pass filter threshold for processing the
consensus matrix (default: \code{0.75}).}

\item{kmNStart}{nstart parameter passed to \code{\link[stats]{kmeans}}.
function. Can be set manually. By default it is \code{1000} for up to
\code{2000} cells and \code{50} for more than \code{2000} cells.}

\item{kmMax}{iter.max parameter passed to \code{\link[stats]{kmeans}}.}

\item{BPPARAM}{(Optional) A \code{BiocParallelParam} object for parallel
processing (default: \code{bpparam()}).}
}
\value{
A consensus matrix summarizing the clustering results across
multiple sub-datasets.
}
\description{
Executes k-means clustering on multiple subsets of data defined by
singular value decomposition (SVD) components, and then aggregates the
results into a consensus matrix.
}
\examples{
library(scater)
library(BiocParallel)
library(splatter)

sce <- splatSimulate(group.prob = rep(1, 5)/5, sparsify = FALSE, 
        batchCells=100, nGenes=1000, method = "groups", verbose = FALSE, 
        dropout.type = "experiment")
sce <- logNormCounts(sce)
cores <- 2
logX <- as.matrix(logcounts(sce))
w <- rowVars_fast(logX, cores)
corMat <- getCorM("spearman", logcounts(sce), w, cores)
v <- doSVD(corMat, nCores=cores)
BPPARAM = MulticoreParam(cores)
consMtx <- runKM(logX, v, BPPARAM=bpparam())

}
