% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{newick}
\alias{newick}
\title{Generate Newick format tree string from tree list object}
\usage{
newick(tree, parent = "1.1", string = "")
}
\arguments{
\item{tree}{Tree list object from \code{\link{build_tree}}}

\item{parent}{Parent ID}

\item{string}{Newick string of parent tree}
}
\value{
String of newick tree
}
\description{
Generate Newick format tree string from tree list object
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50,ncol=100,rank=5)
s <- scNMFSet(x$x)
s <- vb_factorize(s,ranks=seq(2,8),nrun=5)
tree <- build_tree(s,rmax=5)
nw <- newick(tree=tree)
nw
}
