% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{vb_factorize}
\alias{vb_factorize}
\title{Bayesian NMF inference of count matrix}
\usage{
vb_factorize(object, ranks = 2, nrun = 1, verbose = 2,
  progress.bar = TRUE, initializer = "random", Itmax = 10000,
  hyper.update = rep(TRUE, 4), gamma.a = 1, gamma.b = 1,
  Tol = 1e-05, hyper.update.n0 = 10, hyper.update.dn = 1,
  connectivity = TRUE, fudge = NULL, ncores = 1, useC = TRUE,
  unif.stop = TRUE)
}
\arguments{
\item{object}{\code{scNMFSet} object containing count matrix.}

\item{ranks}{Rank for factorization; can be a vector of multiple values.}

\item{nrun}{No. of runs with different initial guesses.}

\item{verbose}{The verbosity level: 
3, each iteration output printed;
2, each run output printed; 
1, each randomized sample output printed;
0, silent.}

\item{progress.bar}{Display progress bar with \code{verbose = 1} for 
multiple runs.}

\item{initializer}{If \code{'random'}, randomized initial conditions; 
\code{'svd2'} for singular value decomposed initial condition.}

\item{Itmax}{Maximum no. of iteration.}

\item{hyper.update}{Vector of four logicals, each indcating whether
hyperparameters \code{c(aw, bw, ah, bh)} should be optimized.}

\item{gamma.a}{Gamma distribution shape parameter.}

\item{gamma.b}{Gamma distribution mean. These two parameters are used for 
fixed hyperparameters with \code{hyper.update} elements \code{FALSE}.}

\item{Tol}{Tolerance for terminating iteration.}

\item{hyper.update.n0}{Initial number of steps in which hyperparameters 
are fixed.}

\item{hyper.update.dn}{Step intervals for hyperparameter updates.}

\item{connectivity}{If \code{TRUE}, connectivity and dispersion will
be calculated after each run. Can be turned off to save memory.}

\item{fudge}{Small positive number used as lower bound for factor matrix 
elements to avoid singularity. If \code{fudge = NULL} (default), 
it will be replaced by \code{.Machine$double.eps}. 
Can be set to 0 to skip 
regularization.}

\item{ncores}{Number of processors (cores) to run. If \code{ncores > 1},
parallelization is attempted.}

\item{useC}{Use C++ version of updates for speed.}

\item{unif.stop}{Terminate if any of columns in basis matrix is uniform.}
}
\value{
Object of class \code{scNMFSet} with factorization slots filled.
}
\description{
Perform variational Bayes NMF and store factor matrices in object
}
\details{
The main input is the \code{scNMFSet} object with count matrix.
This function performs non-negative factorization using Bayesian algorithm
and gamma priors. Slots \code{basis}, \code{coeff}, and \code{ranks} 
are filled.

When run with multiple values of \code{ranks}, factorization is 
       repeated for each rank and the slot \code{measure} contains 
       log evidence and optimal hyperparameters for each rank. 
       With \code{nrun > 1}, the solution
       with the maximum log evidence is stored for a given rank.
}
\examples{
set.seed(1)
x <- simulate_whx(nrow=50,ncol=100,rank=5)
s <- scNMFSet(x$x)
s <- vb_factorize(s,ranks=seq(2,8),nrun=5)
plot(s)
}
