% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_zscore_profile.R
\name{get_zscore_profile}
\alias{get_zscore_profile}
\title{Transform SLRatio with PoN Fragment profile}
\usage{
get_zscore_profile(fragment_profile, pon_profile)
}
\arguments{
\item{fragment_profile}{Sample Profile}

\item{pon_profile}{PoN Profiles}
}
\value{
Dataframe of robust transformed SLratio
}
\description{
Transform SLRatio with PoN Fragment profile
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)

### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)

sample_zscore_segment <- segmentByPSCB(sample_zscore)
}
