% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{make_complex_heatmap}
\alias{make_complex_heatmap}
\title{Plot Annotated Complexheatmap from SingleCellExperiment object}
\usage{
make_complex_heatmap(
  object,
  features = NULL,
  group.by = "ident",
  cells = NULL,
  assayName = "logcounts",
  experiment = NULL,
  group.bar.height = 0.01,
  column_split = NULL,
  col_arrangement = "ward.D2",
  mm_col_dend = 30,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object}

\item{features}{Vector of features to plot. Features can come}

\item{group.by}{Name of one or more metadata columns to annotate columns
by (for example, orig.ident)}

\item{cells}{Cells to retain}

\item{assayName}{"counts" for raw data "scale.data" for log-normalized data}

\item{experiment}{experiment to display}

\item{group.bar.height}{height for group bars}

\item{column_split}{whether to split columns by metadata value}

\item{col_arrangement}{how to arrange columns whether with a dendrogram
(Ward.D2, average, etc.) or exclusively by metadata category}

\item{mm_col_dend}{height of column dendrogram}

\item{...}{additional arguments passed to Heatmap}
}
\value{
a complexheatmap
}
\description{
Plot Annotated Complexheatmap from SingleCellExperiment object
}
\examples{
data("tiny_sce")
make_complex_heatmap(tiny_sce)

}
