% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_marker_features}
\alias{plot_marker_features}
\title{Plot Cluster Marker Genes}
\usage{
plot_marker_features(
  object,
  group_by = "batch",
  num_markers = 5,
  selected_values = NULL,
  return_plotly = FALSE,
  marker_method = "wilcox",
  experiment = "gene",
  hide_technical = NULL,
  unique_markers = FALSE,
  p_val_cutoff = 1,
  ...
)
}
\arguments{
\item{object}{a object}

\item{group_by}{the metadata variable from which to pick clusters}

\item{num_markers}{default is 5}

\item{selected_values}{selected values to display}

\item{return_plotly}{whether to return an interactive plotly plot}

\item{marker_method}{"wilcox"}

\item{experiment}{experiment to plot default gene}

\item{hide_technical}{whether to exclude mitochondrial or ribosomal genes}

\item{unique_markers}{whether to plot only unique marker genes for group}

\item{p_val_cutoff}{cutoff for p value display}

\item{...}{extra parameters passed to ggplot2}
}
\value{
a ggplot with marker genes from group_by
}
\description{
Plot a dot plot of n marker features grouped by cell metadata
available methods are wilcoxon rank-sum test
}
\examples{

data(small_example_dataset)
plot_marker_features(small_example_dataset, group_by = "gene_snn_res.1")

}
